<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= esc($title ?? 'Cek Kelulusan') ?></title>
  <link rel="icon" href="<?= base_url('assets/images/logo1.png') ?>" type="image/png">
</head>
<body style="font-family:Arial;max-width:800px;margin:30px auto;padding:0 14px;">

  <h1 style="margin-bottom:6px;"><?= esc($title ?? 'Cek Kelulusan') ?></h1>
  <p style="margin-top:0;color:#555;">
    Masukkan <b>NISN</b> dan <b>Tanggal Lahir</b> untuk melihat hasil kelulusan.
  </p>

  <?php if (!empty($error)): ?>
    <div style="padding:10px;background:#fee2e2;border:1px solid #f87171;border-radius:10px;margin:12px 0;">
      <?= esc($error) ?>
    </div>
  <?php endif; ?>

  <?php if (!empty($success)): ?>
    <div style="padding:10px;background:#d1fae5;border:1px solid #34d399;border-radius:10px;margin:12px 0;">
      <?= esc($success) ?>
    </div>
  <?php endif; ?>

  <form method="post" action="<?= site_url('kelulusan/cek') ?>" style="margin:14px 0;">
    <?= csrf_field() ?>

    <div style="margin-bottom:10px;">
      <label>NISN</label><br>
      <input type="text" name="nisn" value="<?= esc($nisn ?? '') ?>"
             placeholder="contoh: 1234567890"
             style="width:100%;padding:10px;border:1px solid #ccc;border-radius:8px;">
    </div>

    <div style="margin-bottom:10px;">
      <label>Tanggal Lahir (YYYY-MM-DD)</label><br>
      <input type="date" name="tgl_lahir" value="<?= esc($tgl_lahir ?? '') ?>"
             style="width:100%;padding:10px;border:1px solid #ccc;border-radius:8px;">
      <small style="color:#666;">Contoh: 2007-01-12</small>
    </div>

    <button type="submit"
            style="padding:10px 14px;border:none;border-radius:10px;background:#2563eb;color:#fff;cursor:pointer;">
      Cek Kelulusan
    </button>
  </form>

  <?php if (!empty($row)): ?>
    <hr style="margin:18px 0;">

    <h2>Hasil</h2>
    <table border="1" cellpadding="8" cellspacing="0" width="100%">
      <tr><th align="left" width="30%">Tahun</th><td><?= esc($row['tahun'] ?? '-') ?></td></tr>
      <tr><th align="left">NISN</th><td><?= esc($row['nisn'] ?? '-') ?></td></tr>
      <tr><th align="left">Nama</th><td><?= esc($row['nama'] ?? '-') ?></td></tr>
      <tr><th align="left">Kelas</th><td><?= esc($row['kelas'] ?? '-') ?></td></tr>
      <tr><th align="left">Status</th><td><b><?= esc($row['status'] ?? '-') ?></b></td></tr>
      <?php if (!empty($row['keterangan'])): ?>
        <tr><th align="left">Keterangan</th><td><?= esc($row['keterangan']) ?></td></tr>
      <?php endif; ?>
    </table>

    <div style="margin-top:12px;">
      <?php if (!empty($pdf_url)): ?>
        <a href="<?= esc($pdf_url) ?>" target="_blank"
           style="display:inline-block;margin-right:10px;text-decoration:none;color:#2563eb;">
          Lihat PDF SKL
        </a>
        <a href="<?= esc($pdf_url) ?>" download
           style="display:inline-block;text-decoration:none;color:#2563eb;">
          Download PDF SKL
        </a>
      <?php else: ?>
        <div style="padding:10px;background:#fff7ed;border:1px solid #fb923c;border-radius:10px;">
          PDF SKL belum tersedia.
        </div>
      <?php endif; ?>
    </div>
  <?php endif; ?>

</body>
</html>
